<?php
// You can add session check to ensure this page is accessed after form submission
// if(!isset($_SESSION['form_submitted'])) {
//     header('Location: contact.php');
//     exit;
// }
?>

<!doctype html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Thank You - kavitsu</title>
    <meta name="description" content="Thank you for contacting kavitsu. We will get back to you shortly.">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=0">
    
    <!-- favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="img/favicon.ico">
    
    <!-- Google Fonts -->
    <link href='https://fonts.googleapis.com/css?family=Raleway:400,300,500,600,700,800' rel='stylesheet' type='text/css'>
    
    <!-- Fontawsome CSS -->
    <link rel="stylesheet" href="css/font-awesome.min.css">
    
    <!-- Metarial Iconic Font CSS -->
    <link rel="stylesheet" href="css/material-design-iconic-font.min.css">
    
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="css/bootstrap.min.css">
    
    <!-- Plugins CSS -->
    <link rel="stylesheet" href="css/plugins.css">
    
    <!-- Style CSS -->
    <link rel="stylesheet" href="style.css">
    
    <!-- Color CSS -->
    <link rel="stylesheet" href="css/color.css">
    
    <!-- Responsive CSS -->
    <link rel="stylesheet" href="css/responsive.css">
    
    <!-- Modernizr JS -->
    <script src="js/vendor/modernizr-2.8.3.min.js"></script>
    
    <style>
        .thank-you-area {
            padding: 80px 0;
            text-align: center;
        }
        .thank-you-content {
            background-color: #f9f9f9;
            padding: 50px 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.05);
            max-width: 800px;
            margin: 0 auto;
        }
        .thank-you-content h2 {
            color: #7a4f0d;
            margin-bottom: 20px;
            font-weight: 600;
        }
        .thank-you-content p {
            font-size: 16px;
            line-height: 1.8;
            margin-bottom: 30px;
        }
        .check-icon {
            color: #4CAF50;
            font-size: 60px;
            margin-bottom: 20px;
        }
        .home-button {
            display: inline-block;
            background-color: #7a4f0d;
            color: #fff;
            padding: 10px 25px;
            border-radius: 5px;
            text-transform: uppercase;
            font-weight: 500;
            transition: all 0.3s ease;
            text-decoration: none;
        }
        .home-button:hover {
            background-color: #5d3c08;
            color: #fff;
        }
    </style>
</head>
<body>
    
    <!--Main Wrapper Start-->
    <div class="as-mainwrapper">
        <!--Bg White Start-->
        <div class="bg-white">
            <!--Header Area Start-->
            <header class="header-two">
                <?php include('header.php'); ?>
            </header>
            <!--End of Header Area-->
            
            <!--Breadcrumb Banner Area Start-->
            <div class="breadcrumb-banner-area">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="breadcrumb-text">
                                <h2 class="text-center">THANK YOU</h2>
                                <div class="breadcrumb-bar">
                                    <ul class="breadcrumb text-center">
                                        <li><a href="index.php">Home</a></li>
                                        <li>Thank You</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--End of Breadcrumb Banner Area-->
            
            <!--Thank You Area Start-->
            <div class="thank-you-area">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="thank-you-content">
                                <div class="check-icon">
                                    <i class="zmdi zmdi-check-circle"></i>
                                </div>
                                <h2>Thank You for Contacting Us!</h2>
                                <p>We have received your enquiry and will respond to you as soon as possible. Our team is working diligently to address your request.</p>
                                <p>If you have any urgent concerns, please feel free to call us at <strong>+91 9822 004 240</strong>.</p>
                                <a href="index.php" class="home-button">Return to Home</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--End of Thank You Area-->
            
            <?php include('footer.php'); ?>
            
        </div>
        <!--End of Bg White-->
    </div>
    <!--End of Main Wrapper Area-->
    
    <!-- jquery -->
    <script src="js/vendor/jquery-1.12.4.min.js"></script>
    
    <!-- popper JS -->
    <script src="js/popper.min.js"></script>
    
    <!-- bootstrap JS -->
    <script src="js/bootstrap.min.js"></script>
    
    <!-- plugins JS -->
    <script src="js/plugins.js"></script>
    
    <!-- main JS -->
    <script src="js/main.js"></script>
    
    <script>
        // Auto-redirect to homepage after 30 seconds
        setTimeout(function() {
            window.location.href = 'index.php';
        }, 30000); // 30 seconds
    </script>
</body>
</html>